/*
 * Decompiled with CFR 0.152.
 */
package snake;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import snake.Food;
import snake.LoadImage;
import snake.MKListen;
import snake.mainGame;

public class Snake {
    private final int INITSIZE = 10;
    private static int growLimit;
    private static int currGrow;
    private ArrayList<Point> body = new ArrayList(2);
    private ArrayList<Integer> orient = new ArrayList(2);
    public static final int SIZE = 10;
    private int dir;
    private boolean left;
    private boolean right;
    private boolean up;
    private boolean down;
    private boolean dead;
    private LoadImage load = new LoadImage();
    private BufferedImage[][] snakeImg = this.load.getImage(this.getClass().getResource("/res/Snake.png"), this.snakeImg, 4, 3, 10);

    public Snake() {
        this.restart();
    }

    public void restart() {
        this.body.removeAll(this.body);
        this.orient.removeAll(this.orient);
        this.dir = 0;
        currGrow = 0;
        growLimit = 0;
        int i = 0;
        while (i < 100) {
            this.body.add(new Point((mainGame.WIDTH + 10) / 2 - 100 + i, (mainGame.HEIGHT + 10) / 2));
            this.orient.add(new Integer(this.dir));
            i += 10;
        }
        this.left = false;
        this.right = true;
        this.up = false;
        this.down = false;
        this.dead = false;
    }

    public void update(MKListen mkListen, Food f) {
        if (mkListen.isUp() && !this.down) {
            this.up = true;
            this.down = false;
            this.left = false;
            this.right = false;
            this.dir = 2;
        }
        if (mkListen.isDown() && !this.up) {
            this.up = false;
            this.down = true;
            this.left = false;
            this.right = false;
            this.dir = 3;
        }
        if (mkListen.isRight() && !this.left) {
            this.up = false;
            this.down = false;
            this.left = false;
            this.right = true;
            this.dir = 0;
        }
        if (mkListen.isLeft() && !this.right) {
            this.up = false;
            this.down = false;
            this.left = true;
            this.right = false;
            this.dir = 1;
        }
        Point next = new Point();
        next.x = this.body.get((int)(this.body.size() - 1)).x;
        next.y = this.body.get((int)(this.body.size() - 1)).y;
        this.calcNext(next);
        if (this.isBound(next)) {
            this.checkDead(next);
            if (!this.dead) {
                this.body.add(next);
                this.orient.add(this.dir);
                if (growLimit == 0) {
                    this.orient.remove(0);
                    this.body.remove(0);
                }
            }
        }
        Point food = new Point();
        Point head = new Point();
        food = f.getP();
        head = this.body.get(this.body.size() - 1);
        if (Math.pow(head.x - food.x, 2.0) + Math.pow(head.y - food.y, 2.0) < Math.pow(10.0, 2.0)) {
            f.remove();
            growLimit += 5;
        }
        if (currGrow < growLimit) {
            ++currGrow;
        } else {
            growLimit = 0;
            currGrow = 0;
        }
    }

    private boolean isBound(Point p) {
        if (p.x - 5 < mainGame.WIDTH - 10 && p.x + 5 > 10 && p.y - 5 < mainGame.HEIGHT - 10 && p.y + 5 > 20) {
            return true;
        }
        this.dead = true;
        return false;
    }

    private void calcNext(Point next) {
        if (this.up) {
            next.y -= 10;
        }
        if (this.down) {
            next.y += 10;
        }
        if (this.left) {
            next.x -= 10;
        }
        if (this.right) {
            next.x += 10;
        }
    }

    private void checkDead(Point p) {
        for (Point self : this.body) {
            if (p.x != self.x || p.y != self.y) continue;
            this.dead = true;
        }
    }

    public boolean checkFoodOL(Point p) {
        for (Point self : this.body) {
            if (p.x != self.x || p.y != self.y) continue;
            return true;
        }
        return false;
    }

    public boolean isDead() {
        return this.dead;
    }

    public void render(Graphics2D g) {
        g.setColor(Color.BLACK);
        g.setFont(new Font("Century Gothic", 0, 8));
        g.drawString("Score: " + (this.body.size() - 10), 15, 30);
        g.fillRect(0, 0, mainGame.WIDTH, 20);
        g.fillRect(0, 0, 10, mainGame.HEIGHT);
        g.fillRect(mainGame.WIDTH - 10, 0, 10, mainGame.HEIGHT);
        g.fillRect(0, mainGame.HEIGHT - 10, mainGame.WIDTH, 10);
        int i = 0;
        while (i < this.body.size()) {
            Point p = this.body.get(i);
            if (p == this.body.get(0)) {
                g.drawImage((Image)this.snakeImg[this.orient.get(1)][1], p.x - 5, p.y - 5, null);
            } else if (p == this.body.get(this.body.size() - 1)) {
                g.drawImage((Image)this.snakeImg[this.orient.get(i)][0], p.x - 5, p.y - 5, null);
            } else {
                g.drawImage((Image)this.snakeImg[this.orient.get(i)][2], p.x - 5, p.y - 5, null);
            }
            ++i;
        }
    }
}

